/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.util.BusinessBASICToken;
import com.webcodepro.applecommander.util.BusinessBASICTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class BusinessBASICFileFilter
implements FileFilter {
    @Override
    public byte[] filter(FileEntry fileEntry) {
        BusinessBASICToken token;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArray, true);
        BusinessBASICTokenizer tokenizer = new BusinessBASICTokenizer(fileEntry);
        boolean firstLine = true;
        boolean firstData = true;
        int nestLevels = 0;
        while (tokenizer.hasMoreTokens() && (token = tokenizer.getNextToken()) != null) {
            if (token.isLineNumber()) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    printWriter.println();
                }
                firstData = true;
                printWriter.print(token.getLineNumber());
                printWriter.print("   ");
                if (nestLevels <= 0) continue;
                for (int i = 0; i < nestLevels; ++i) {
                    printWriter.print("  ");
                }
                continue;
            }
            if (token.isToken()) {
                if (!firstData) {
                    printWriter.print(" ");
                }
                printWriter.print(token.getTokenString());
                firstData = false;
                if (token.isIndenter()) {
                    ++nestLevels;
                    continue;
                }
                if (!token.isOutdenter()) continue;
                --nestLevels;
                continue;
            }
            if (token.isCommandSeparator() || token.isExpressionSeparator()) {
                printWriter.print(token.getStringValue());
                firstData = true;
                continue;
            }
            if (!firstData) {
                printWriter.print(" ");
            }
            printWriter.print(token.getStringValue().trim());
            firstData = false;
        }
        printWriter.close();
        return byteArray.toByteArray();
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        String fileName = fileEntry.getFilename().trim();
        if (!fileName.toLowerCase().endsWith(".ba3")) {
            fileName = fileName + ".ba3";
        }
        return fileName;
    }
}

